/*** 1.   ũƮ ***/

SELECT seq
	, CONVERT(NVARCHAR(36),NEWID()) code
	, DATEADD(mi, seq-1, '2001-01-01') date 
INTO TB_FMain
FROM (SELECT ROW_NUMBER() OVER (ORDER BY a.number) seq
	 FROM master..spt_values a, master..spt_values b 
	 WHERE a.type = 'P'
	 AND a.number BETWEEN 1 AND 1000
	 AND b.type = 'P'
	 AND b.number BETWEEN 1 AND 100
) c
SELECT seq
	, CASE WHEN seq <= 25000 THEN 1 
	  WHEN seq <= 50000 THEN 2 
	  WHEN seq <= 75000 THEN 3
	  ELSE 4 END group_id
	, CONVERT(INT, LEFT(seq * num * ASCII(SUBSTRING(code, 1, 1)), 2)) value 
INTO TB_FSub
FROM TB_FMain a, (SELECT 1 num UNION ALL SELECT 2 num UNION ALL SELECT 3 num) b

CREATE CLUSTERED INDEX CIDX_FMain ON TB_FMain(date)
CREATE INDEX NIDX01_FSub ON TB_FSub(group_id,seq) INCLUDE (value)
GO

/*** Լ  ***/
CREATE FUNCTION FN_SUM_VALUE ( @seq INT )
RETURNS INT
AS
BEGIN
DECLARE @value INT
	SELECT @value = SUM(value)
	FROM TB_FSub
	WHERE seq = @seq AND group_id  IN (1,2)
	RETURN @value
END
GO


/*** 2. [AS-IS] SQL    ȹ ***/

SELECT f.seq, f.code, dbo.FN_SUM_VALUE(seq) sum_value
FROM TB_Fmain f
WHERE date BETWEEN '2001-01-01 00:00:00.000' AND '2001-01-31 23:59:59.997'
GO


/*** 6. [TO-BE]   ***/

SELECT f.seq, f.code ,(SELECT SUM(value) sum_value 
			FROM TB_FSub s 
			WHERE s.seq = f.seq 
			AND s.group_id IN (1,2)) sum_value
FROM TB_Fmain f
WHERE date BETWEEN '2001-01-01 00:00:00.000' AND '2001-01-31 23:59:59.997'
GO